<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Test</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
        }

        h1, h2, h3 {
            color: #333;
            text-align: center;
        }

        ul {
            list-style-type: none;
            padding: 0;
        }

        li {
            margin-bottom: 10px;
        }

        label {
            font-weight: bold;
        }

        input[type="text"], textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
            resize: vertical;
        }

        input[type="submit"] {
            background-color: #4CAF50;
            color: white;
            padding: 15px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }

        input[type="submit"]:hover {
            background-color: #45a049;
        }

        .container {
            max-width: 400px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        /* CSS for the list item containing the question and the "Edit" button */
        li.question-item {
            margin-bottom: 10px;
            border-bottom: 1px solid #ccc; /* Add a border between questions */
            padding-bottom: 5px;
            display: flex;
            align-items: center;
        }

        li.question-item .question-text {
            flex-grow: 1; /* Make the question text take up remaining space */
        }

        li.question-item .edit-link {
            padding: 5px 10px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        li.question-item .edit-link:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>
    <!-- Navigācijas josla -->
    <div id="navbar">
        <div id="logo">LOGO</div>
        <button onclick="location.href='../php/list_tests.php'">Visi testi</button>
        <button id="createTestBtn" onclick="openTestManagementView()">Testu veidošana</button>
        <!-- Lietotāja profila nolaižamā izvēlne -->
        <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
            <div class="dropdown-content" id="dropdownContent">
                <a href="../html/iestatijumi.html">Iestatījumi</a>
                <a href="../html/vesture.html">Vēsture</a>
                <a href="../html/rezultati.html">Rezultāti</a>
                <a href="../html/testu_parvaldisana.html">Testu pārvaldīšana</a>
                <a href="../html/sakumlapa1.html" onclick="logout()">Iziet</a>
                <!-- Teacher Dashboard Button -->
                <a href="teacher_dashboard.html" id="teacherDashboardBtn" style="display: none;">Skolotāju panelis</a>
            </div>
        </div>
    </div>

    <h1>Testu rediģēšana</h1>

    <?php
    // Check if test ID is provided in the URL
    if (!isset($_GET['id'])) {
        // Redirect to an error page or handle the error accordingly
        header("Location: error.php");
        exit();
    }

    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "quiz_db";

    // Izveido savienojumu
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Pārbauda savienojumu
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Paņem testa ID no URL
    $testId = $_GET['id'];

    // Paņem testa informāciju no datubāzes
    $sql = "SELECT * FROM tests WHERE id = $testId";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Tests atrasts
        $row = $result->fetch_assoc();
        echo "<h2>Rediģēt testa detaļas</h2>";
        echo "<form action='update_test.php' method='POST'>";
        // Iekļauj testa ID slēptajā ievades laukā
        echo "<input type='hidden' name='testId' value='" . $row['id'] . "'>";
        echo "<label for='testName'>Nosaukums:</label>";
        echo "<input type='text' id='testName' name='testName' value='" . $row['name'] . "'>";
        echo "<label for='testDescription'>Apraksts:</label>";
        echo "<textarea id='testDescription' name='testDescription'>" . $row['description'] . "</textarea>";
        echo "<label for='testCategory'>Kategorija:</label>";
        echo "<input type='text' id='testCategory' name='testCategory' value='" . $row['category'] . "'>";
        echo "<input type='submit' value='Saglabāt izmaiņas'>";
        echo "</form>";

        // Iegūst ar testu saistītos jautājumus no datu bāzes
        $sql_questions = "SELECT * FROM questions WHERE test_id = $testId";
        $result_questions = $conn->query($sql_questions);

        if ($result_questions->num_rows > 0) {
            // Parādīt jautājumu sarakstu ar rediģēšanas pogu
            echo "<h3>Jautājumi:</h3>";
            echo "<ul>";
            while($row_question = $result_questions->fetch_assoc()) {
                echo "<li class='question-item'>" . $row_question['question'] . " - ";
                echo "<a class='edit-link' href='../php/edit_question.php?id=" . $row_question['id'] . "'>Rediģēt</a></li>";
            }
            echo "</ul>";
        } else {
            echo "Šim testam netika atrasts neviens jautājums.";
        }
    } else {
        // Tests nav atrasts, izvada kļūdas paziņojumu
        echo "Tests netika atrasts.";
    }

    // Close database connection
    $conn->close();
    ?>

    <!-- Form to add a new question -->
    <div class="container">
        <h2>Pievienot jaunu jautājumu</h2>
        <form action="../php/add_question.php" method="POST">
            <input type="hidden" name="testId" value="<?php echo $testId; ?>">
            <label for="question">Jautājums:</label>
            <input type="text" id="question" name="question" required>
            <label for="option1">Atbilde 1:</label>
            <input type="text" id="option1" name="option1" required>
            <label for="option2">Atbilde 2:</label>
            <input type="text" id="option2" name="option2" required>
            <label for="option3">Atbilde 3:</label>
            <input type="text" id="option3" name="option3" required>
            <label for="option4">Atbilde 4:</label>
            <input type="text" id="option4" name="option4" required>
            <label for="correct">Pareizā atbilde (1-4):</label>
            <input type="number" id="correct" name="correct" min="1" max="4" required>
            <input type="submit" value="Pievienot jautājumu">
        </form>
    </div>

    <script>
        // JavaScript funkcija, kas novirza uz sakumlapa.html lapu
        function redirectToHomePage() {
            window.location.href = '../html/sakumlapa.html';
        }
        // Function to open test creation view
        function openTestCreationView() {
            window.location.href = '../html/testu_veidosanai.html';
        }
    </script>
</body>
</html>
